var KeyPathNode = require('../../key_path/KeyPathNode');
var Property = require('../../property/Property');
var TextAnimator = require('./TextAnimator');

function Text(element, parent) {

	var instance = {}

	var state = {
		element: element,
		parent: parent,
		properties: _buildPropertyMap()
	}

	function setDocumentData(_function) {
		var previousValue;
		var textDocumentUpdater = function(data) {
			var newValue = _function(element.textProperty.currentData);
			if (previousValue !== newValue) {
				previousValue = newValue;
				return Object.assign({}, data, newValue, {__complete: false});
			}
			return data
		}
		element.textProperty.addEffect(textDocumentUpdater);
	}

	function addAnimators() {
		var animatorProperties = [];
		var animators = element.textAnimator._animatorsData;
		var i, len = animators.length;
		var textAnimator;
		for (i = 0; i < len; i += 1) {
			textAnimator = TextAnimator(animators[i])
			animatorProperties.push({
				name: element.textAnimator._textData.a[i].nm || 'Animator ' + (i+1), //Fallback for old animations
				value: textAnimator
			})
		}
		return animatorProperties;
	}

	function _buildPropertyMap() {
		return [
			{
				name:'Source',
				value: {
					setValue: setDocumentData
				}
			}
		].concat(addAnimators())
	}

	var methods = {
	}

	return Object.assign(instance, methods, KeyPathNode(state));

}

module.exports = Text;