"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _glShader = require("gl-shader");

var _glShader2 = _interopRequireDefault(_glShader);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var VERT = "attribute vec2 _p;\nvarying vec2 _uv;\nvoid main() {\ngl_Position = vec4(_p,0.0,1.0);\n_uv = vec2(0.5, 0.5) * (_p+vec2(1.0, 1.0));\n}";

// these functions make a GLSL code that map the texture2D uv to preserve ratio for a given ${r} image ratio.
// there are different modes:
var resizeModes = {
  cover: function cover(r) {
    return ".5+(uv-.5)*vec2(min(ratio/" + r + ",1.),min(" + r + "/ratio,1.))";
  },
  contain: function contain(r) {
    return ".5+(uv-.5)*vec2(max(ratio/" + r + ",1.),max(" + r + "/ratio,1.))";
  },
  stretch: function stretch() {
    return "uv";
  }
};

var makeFrag = function makeFrag(transitionGlsl, resizeMode) {
  var r = resizeModes[resizeMode];
  if (!r) throw new Error("invalid resizeMode=" + resizeMode);
  return "precision highp float;varying vec2 _uv;uniform sampler2D from, to;uniform float progress, ratio, _fromR, _toR;vec4 getFromColor(vec2 uv){return texture2D(from," + r("_fromR") + ");}vec4 getToColor(vec2 uv){return texture2D(to," + r("_toR") + ");}\n" + transitionGlsl + "\nvoid main(){gl_FragColor=transition(_uv);}";
};

exports.default = function (gl, transition) {
  var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

  var _resizeMode$options = _extends({ resizeMode: "cover" }, options),
      resizeMode = _resizeMode$options.resizeMode;

  var shader = (0, _glShader2.default)(gl, VERT, makeFrag(transition.glsl, resizeMode));
  shader.bind();
  shader.attributes._p.pointer();

  return {
    draw: function draw(progress, from, to) {
      var width = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : gl.drawingBufferWidth;
      var height = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : gl.drawingBufferHeight;
      var params = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : {};

      shader.bind();
      shader.uniforms.ratio = width / height;
      shader.uniforms.progress = progress;
      shader.uniforms.from = from.bind(0);
      shader.uniforms.to = to.bind(1);
      shader.uniforms._fromR = from.shape[0] / from.shape[1];
      shader.uniforms._toR = to.shape[0] / to.shape[1];
      var unit = 2;
      for (var _key in transition.paramsTypes) {
        var value = _key in params ? params[_key] : transition.defaultParams[_key];
        if (transition.paramsTypes[_key] === "sampler2D") {
          if (!value) {
            console.warn("uniform[" + _key + "]: A texture MUST be defined for uniform sampler2D of a texture");
          } else if (typeof value.bind !== "function") {
            throw new Error("uniform[" + _key + "]: A gl-texture2d API-like object was expected");
          } else {
            shader.uniforms[_key] = value.bind(unit++);
          }
        } else {
          shader.uniforms[_key] = value;
        }
      }
      gl.drawArrays(gl.TRIANGLES, 0, 3);
    },
    dispose: function dispose() {
      shader.dispose();
    }
  };
};